function Main_LVQ
% Main_LVQ
%   quantification (LVQ) et visualisation de donnees en 3D (espace RVB)


%GENERATION DATA---------------------------------------------

%nb vecteurs source
nb_vect = 50; %1000;

% generation des points 3D a quantifier 
data = randn(3, nb_vect);

% energie max d'un vecteur source 
% ici on majore cette Energie (cf. max(abs(data( ... ))) ) pour ne pas avoir 
% lors de la visualisation finale, des points juste sur les bords.
Emax = sqrt( max(abs(data(1,:)))^2 + ...
             max(abs(data(2,:)))^2 + ...
             max(abs(data(3,:)))^2 )

% initialisation-----------------------------------------------------------

% VARIABLES ********************************

%nb representants dans un "cube fondamental" 
nb_repres = 27;

% facteurs de normalisation
f = 1.5 / Emax %128;
b = 3;

Centre = 0; % les donnees sont centrees

% TAMPONS 

%pour calcul repres affiches
%repres1 = zeros(1, 3);
%repres2 = zeros(1, 3);
%repres3 = zeros(1, 3);
%vect. representant


%liste des index des representants utilises 
%aux 3 etages de quantification
listeIndex1 = zeros(1, nb_repres);
listeIndex2 = zeros(nb_repres, nb_repres);
listeIndex3 = zeros(nb_repres, nb_repres, nb_repres);

%******************************************

% visualisation data dans espace source
figure(2);
clf;

plot3( data(1,:), ...
       data(2,:), ...
       data(3,:), 'r.');    
hold on;

% QUANTIFICATION data---------------------------------------------

% 1er etage de  quantification
% *********************************************

% normalisation 
%data1 = zeros(3, nb_vect);
data1 = data * f;

% quantification rapide (reseau cubique)
Y1 = zeros(3, nb_vect);
Y1(1,:) = quantifBase( data1(1,:) );
Y1(2,:) = quantifBase( data1(2,:) );
Y1(3,:) = quantifBase( data1(3,:) );

% Affichage dans espace source

for i = 1 : nb_vect
    %represTOindex
    index1 = represTOindex ( [Y1(1,i), Y1(2,i), Y1(3,i)] );
    
    %memorisation
    listeIndex1( index1 ) = 1;
end

figure(2);
for i = 1 : nb_repres  
    if listeIndex1( i ) == 1 
        
        %indexTOrepres
        repres = indexTOrepres( i );
        
        %repres dans espace source
        repres_visu = ( double( repres ) /f ) + double( Centre ) ; 
        
        %plot
        plot3(repres_visu(1), repres_visu(2), repres_visu(3), 'g*');
        hold on;
        plotCube(1/f, [repres_visu(1), repres_visu(2), repres_visu(3)], 'g');
        hold on;
     end
end

input ("Press <enter> to continue: ", "s");

% 2e etage de quantification **********************************************

% recentrage
data2_recentree = zeros(3, nb_vect);
data2_recentree(1,:) = data1(1,:) - double( Y1(1,:) );
data2_recentree(2,:) = data1(2,:) - double( Y1(2,:) );
data2_recentree(3,:) = data1(3,:) - double( Y1(3,:) );

% normalisation
%data2 = zeros(3, nb_vect);
data2 = data2_recentree * b;

% quantification rapide
Y2 = zeros(3, nb_vect);
Y2(1,:) = quantifBase( data2(1,:) );
Y2(2,:) = quantifBase( data2(2,:) );
Y2(3,:) = quantifBase( data2(3,:) );

%Affichage dans espace source

for i = 1 : nb_vect %parcours vecteurs de la source
    
    index1 = represTOindex ( [Y1(1,i), Y1(2,i), Y1(3,i)] );
    %index repres du 1er etage LVQ
    
    index2 = represTOindex ( [Y2(1,i), Y2(2,i), Y2(3,i)] );
    %index repres du 2nd etage LVQ
    
    listeIndex2(index1, index2) = 1;
    %memorisation 
end
    
figure(2);
for i = 1 : nb_repres
    for j = 1 : nb_repres
        
        if listeIndex2(i, j) == 1     
            
            %indexTOrepres
            repres1 = indexTOrepres( i );
            repres2 = indexTOrepres( j );       
            
            %repres dans espace source
            repres_visu = ( double( repres2 ) / b + double( repres1 ) ) / f + ...
                double( Centre );
       
            %plot
            plot3(repres_visu(1), repres_visu(2), repres_visu(3), 'b*');
            hold on;
            plotCube(1/(f * b), [repres_visu(1), repres_visu(2), repres_visu(3)], 'b');
            hold on;
            
        end       
     end
end

input ("Press <enter> to continue: ", "s");

% 3e etage de  quantification **********************************************

% recentrage
data3_recentree = zeros(3, nb_vect);
data3_recentree(1,:) = data2(1,:) - double( Y2(1,:) );
data3_recentree(2,:) = data2(2,:) - double( Y2(2,:) );
data3_recentree(3,:) = data2(3,:) - double( Y2(3,:) );

% normalisation
%data3 = zeros(3, nb_vect);
data3 = data3_recentree * b;

% quantification rapide
Y3 = zeros(3, nb_vect);
Y3(1,:) = quantifBase( data3(1,:) );
Y3(2,:) = quantifBase( data3(2,:) );
Y3(3,:) = quantifBase( data3(3,:) );

% Affichage dans espace source

for i = 1 : nb_vect %parcours vecteurs de la source
    
    index1 = represTOindex ( [Y1(1,i), Y1(2,i), Y1(3,i)] );
    %index repres du 1er etage LVQ
    
    index2 = represTOindex ( [Y2(1,i), Y2(2,i), Y2(3,i)] );
    %index repres du 2nd etage LVQ
    
    index3 = represTOindex ( [Y3(1,i), Y3(2,i), Y3(3,i)] );
    %index repres du 3e etage LVQ
    
    listeIndex3(index1, index2, index3) = 1;
    %memorisation 
end
    
figure(2);
for i = 1 : nb_repres
    for j = 1 : nb_repres
        for k = 1 : nb_repres
            
            if listeIndex3(i, j, k) == 1     
                
                %indexTOrepres
                repres1 = indexTOrepres( i );
                repres2 = indexTOrepres( j );
                repres3 = indexTOrepres( k );
         
                %repres dans espace source
                repres_visu = ( ( double( repres3 ) / b + double( repres2 ) ) / b + double( repres1 ) ) / f + ...
                    double( Centre );
       
                %plot
                plot3(repres_visu(1), repres_visu(2), repres_visu(3), 'm*');
                hold on;
                plotCube(1/(f * b * b), [repres_visu(1), repres_visu(2), repres_visu(3)], 'm');
                hold on;
            end 
            
        end
    end
end

input ("Press <enter> to continue: ", "s");

% FIN QUANTIFICATION DATA ***************************************************

figure(2);
rotate3d on;
grid;
%opengl;
axis square;

% sauvegarde : 
% liste des index des representants des 3 etages de LVQ

% listeIndex = cell(1, 3);
% listeIndex{1, 1} = listeIndex_1;
% listeIndex{1, 2} = listeIndex_2;
% listeIndex{1, 3} = listeIndex_3;

%set(gcbo, 'UserData', listeIndex);

% FIN -----------------------------------------------------------

