% DPCM  

clear all; close all; clc;

%=================================
%  DPCM coder                  
%=================================
% Question1
%----------
I_test = [  12  20  35  50  55  60;
            26  38  59  80  82  90;
            120 125 152 156 160 162;
            152 125 118 110 100 30  ];
        
[m, n] = size(I_test);

% - Predicted Image
Ip = zeros(m,n);

% - Image of the prediction error
E = zeros(m,n);

% - Image of the quantized errors
Eq = zeros(m,n);

% - Reconstructed Image
Ir = zeros(m,n);

% Question2
%----------
Ip(:,1) = NaN;  % prediction not possible for the 1rst column
E(:,1) = NaN;   % No prediction error to estimate for the 1rst column
Eq(:,1) = NaN;  % No quantization error for the 1rst column
Ir(:,1) = I_test(:,1);   % The 1st column is transmitted without loss

% Question 4 (DPCM coder)
%----------
for i = 1:m % row scan 
    for j = 2:n % column scan
        Ip(i,j) = Ir(i, j-1);   % prdiction P(X) = A
        E(i,j) = I_test(i,j) - Ip(i,j);     % prediction error 
        Eq(i,j) = quantification( E(i,j) ); % quantized prediction error 
        Ir(i,j) = Ip(i,j) + Eq(i,j);
    end
end
% Remarque:
% the results correspond to those of the exercice


%====================================
% II- Implementation of the decodeur=
%====================================
Ir_dec = zeros(m,n); %initialization of the reconstructed image on the decoder side
Ir_dec(:,1) = I_test(:,1); % 1rst column transmitted without loss
Ip_dec = zeros(m,n);
Ip_dec(:,1) = NaN;

for i = 1:m
    for j = 2:n
        Ip_dec(i,j) = Ir_dec(i, j-1);
        Ir_dec(i,j) = Eq(i,j) + Ip_dec(i,j);
    end
end
% Remarque:
% Ir_dec and Ir have to be identical 


%===========================
% III- DPCM - adaptive Coder
%===========================
% - image loading  
%--------------------------------------
I = imread('circuit.tif');
figure(1)
imshow(uint8(I));
title('Original image');
I = double(I);
[m,n] = size(I);

% - Predictor : P(X) = A
%--------------------------
Ip1 = zeros(m,n);
Ip1(:,1) = NaN;
E1 = zeros(m,n);
E1(:,1) = NaN;
Eq1 = zeros(m,n);
Eq1(:,1) = NaN;
Ir1 = zeros(m,n);
Ir1(:,1) = I(:,1);

for i = 1:m % i : row index
    for j = 2:n % j : column index
        Ip1(i,j) = Ir1(i, j-1);   % prediction P(X) = A
        E1(i,j) = I(i,j) - Ip1(i,j);  % prediction error
        Eq1(i,j) = quantification( E1(i,j) ); % quantized error
        Ir1(i,j) = Ip1(i,j) + Eq1(i,j);
    end
end
PSNR1 = 10*log10(255^2/sum(sum(Eq1(:,2:end).^2/(m*(n-1)))));
figure(2)
imagesc(Eq1)
colormap('gray')
title('Quantized prediction errors with predictor: P(X) = A');

% - Adaptive DPCM
%----------------------
Ip2 = zeros(m,n);
Ip2(:,1) = NaN;
E2 = zeros(m,n);
E2(:,1) = NaN;
Eq2 = zeros(m,n);
Eq2(:,1) = NaN;
Ir2 = zeros(m,n);
Ir2(:,1) = I(:,1);

% - 1st image line initialization (cf. P(X) = A)
for j = 2:n
    Ip2(1,j) = Ir2(1, j-1);
    E2(1,j) = I(1,j) - Ip2(1,j);
    Eq2(1,j) = quantification( E2(1,j) );
    Ir2(1,j) = Ip2(1,j) + Eq2(1,j);
end
% - Other lines 
for i = 2:m 
    for j = 2:n 
        A = Ir2(i,j-1);
        B = Ir2(i-1,j-1);
        C = Ir2(i-1,j);
        delta1 = abs( A - B );    % |A - B|
        delta2 = abs( B - C );    % |B - C|
        if delta1 > delta2
            Ip2(i,j) = A;
        else
            Ip2(i,j) = C;
        end
        E2(i,j) = I(i,j) - Ip2(i,j);
        Eq2(i,j) = quantification( E2(i,j) );
        Ir2(i,j) = Ip2(i,j) + Eq2(i,j);
    end
end
PSNR2 = 10*log10(255^2/sum(sum(Eq2(:,2:end).^2/(m*(n-1)))));
figure(3)
imagesc(Eq2)
colormap('gray')
title('Quantized prediction errors with the Adaptive Predictor');


%=============================
% IV- If there are error "transmission" (we emulate them)
%=============================
Eq1(10:15,10:15) = 255;   % Errors that occur
Eq2(10:15,10:15) = 255;

% - Predictor P(X) = A
%--------------------
Ir1_dec = zeros(m,n);
Ir1_dec(:,1) = I(:,1);
Ip1_dec = zeros(m,n);
Ip1_dec(:,1) = NaN;

for i = 1:m
    for j = 2:n
        Ip1_dec(i,j) = Ir1_dec(i, j-1);
        Ir1_dec(i,j) = Eq1(i,j) + Ip1_dec(i,j);
    end
end
figure(4)
imshow(uint8(Ir1_dec))
colormap('gray')
title('Reconstructed image [with P(X) = A]');

% - Adaptive decoder
%---------------------
Ir2_dec = zeros(m,n);
Ir2_dec(:,1) = I(:,1);
Ip2_dec = zeros(m,n);
Ip2_dec(:,1) = NaN;

% - Initialization (1st line)
for j = 2:n
    Ip2_dec(1,j) = Ir2_dec(1, j-1);
    Ir2_dec(1,j) = Ip2_dec(1,j) + Eq2(1,j);
end
% - Other lines 
for i = 2:m 
    for j = 2:n 
        A = Ir2_dec(i,j-1);
        B = Ir2_dec(i-1,j-1);
        C = Ir2_dec(i-1,j);
        delta1 = abs( A - B );    % |A - B|
        delta2 = abs( B - C );    % |B - C|
        if delta1 > delta2
            Ip2_dec(i,j) = A;
        else
            Ip2_dec(i,j) = C;
        end
        Ir2_dec(i,j) = Ip2_dec(i,j) + Eq2(i,j);
    end
end
figure(5)
imshow(uint8(Ir2_dec))
colormap('gray')
title('Reconstructed image [with the Adaptive predictor]');